--
-- Table structure for table `gk_app_items`
--

DROP TABLE IF EXISTS `gk_app_items`;
CREATE TABLE `gk_app_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `app_alias` varchar(63) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_description` varchar(63) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `has_frontend` tinyint(1) DEFAULT '0',
  `has_backend` tinyint(1) DEFAULT '0',
  `show_left_to_adminmenu` tinyint(1) DEFAULT '0',
  `show_right_to_adminmenu` tinyint(1) DEFAULT '0',
  `show_in_app_menu` tinyint(1) DEFAULT NULL,
  `show_in_main` tinyint(1) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  UNIQUE KEY `app_alias` (`app_alias`),
  KEY `show_in_app_menu` (`show_in_app_menu`),
  KEY `show_in_main` (`show_in_main`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `gk_bannedip_items`
--

DROP TABLE IF EXISTS `gk_bannedip_items`;
CREATE TABLE `gk_bannedip_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip_address` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_block_categories`
--

DROP TABLE IF EXISTS `gk_block_categories`;
CREATE TABLE IF NOT EXISTS `gk_block_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_block_config`
--

DROP TABLE IF EXISTS `gk_block_config`;

CREATE TABLE `gk_block_config` (
  `section` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `value` text COLLATE utf8mb4_unicode_ci,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified_by_id` bigint(20) NOT NULL DEFAULT '0',
  UNIQUE KEY `primary_key` (`section`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_block_items`
--

DROP TABLE IF EXISTS `gk_block_items`;
CREATE TABLE IF NOT EXISTS `gk_block_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `original_block` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `display_in_menu` tinyint(1) NOT NULL DEFAULT '1',
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title_category_id` (`category_id`,`title`),
  KEY `category_id` (`category_id`),
  KEY `title` (`title`),
  KEY `original_block` (`original_block`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`),
  KEY `display_in_menu` (`display_in_menu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_block_menu_association`
--

DROP TABLE IF EXISTS `gk_block_menu_association`;
CREATE TABLE IF NOT EXISTS `gk_block_menu_association` (
  `id` int(11) unsigned NOT NULL DEFAULT '0',
  `menu_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_blog_categories`
--

DROP TABLE IF EXISTS `gk_blog_categories`;
CREATE TABLE IF NOT EXISTS `gk_blog_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(20) unsigned DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) DEFAULT NULL,
  `locked_by_id` bigint(20) DEFAULT NULL,
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `summary_intro_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `description_intro_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description_background_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(3) DEFAULT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `items_per_page` int(11) NOT NULL DEFAULT '10',
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `guid` (`guid`),
  KEY `parent_id` (`parent_id`),
  KEY `title` (`title`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `date_available` (`date_available`),
  KEY `date_expiry` (`date_expiry`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `sort_order` (`sort_order`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_blog_items`
--

DROP TABLE IF EXISTS `gk_blog_items`;
CREATE TABLE IF NOT EXISTS `gk_blog_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description_alternative_title` varchar(255) COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `summary_secondary_headline` text COLLATE utf8mb4_unicode_ci,
  `summary_intro_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary_intro_image_caption` text COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `description_secondary_headline` text COLLATE utf8mb4_unicode_ci,
  `description_intro_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description_background_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description_intro_image_caption` text COLLATE utf8mb4_unicode_ci,
  `description_custom_html_code` text COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) DEFAULT NULL,
  `locked_by_id` bigint(20) DEFAULT NULL,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `title` (`title`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `status` (`status`),
  KEY `version` (`version`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `sort_order` (`sort_order`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_blog_categories_items`
--

DROP TABLE IF EXISTS `gk_blog_categories_items`;
CREATE TABLE IF NOT EXISTS `gk_blog_categories_items` (
  `id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `cid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `is_primary` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`cid`),
  KEY `is_primary` (`is_primary`),
  UNIQUE KEY `primary_category` (`id`,`cid`,`is_primary`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_config`
--

DROP TABLE IF EXISTS `gk_config`;
CREATE TABLE IF NOT EXISTS `gk_config` (
  `section` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `value` text COLLATE utf8mb4_unicode_ci,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified_by_id` bigint(16) NOT NULL DEFAULT '0',
  UNIQUE KEY `primary_key` (`section`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_contact_categories`
--

-- --------------------------------------------------------
DROP TABLE IF EXISTS `gk_contact_categories`;
CREATE TABLE `gk_contact_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `parent_id` int(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `summary` text COLLATE utf8mb4_unicode_ci,
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `version` decimal(20,2) DEFAULT '1.00',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `parent_id_vfn` (`parent_id`,`virtual_filename`),
  KEY `status` (`status`),
  KEY `parent_id` (`parent_id`),
  KEY `version` (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
-- --------------------------------------------------------

--
-- Table structure for table `gk_contact_items`
--


DROP TABLE IF EXISTS `gk_contact_items`;
CREATE TABLE `gk_contact_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `branch` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_person` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `pobox` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `province` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tollfree` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_org_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(18,15) DEFAULT NULL,
  `longitude` decimal(18,15) DEFAULT NULL,
  `map_zoom` tinyint(2) DEFAULT NULL,
  `display_email` tinyint(1) NOT NULL DEFAULT '0',
  `display_map` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `additional_info` text COLLATE utf8mb4_unicode_ci,
  `additional_options` text COLLATE utf8mb4_unicode_ci,
  `status` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `version` decimal(20,2) DEFAULT '1.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_id_vfn` (`category_id`,`virtual_filename`),
  KEY `status` (`status`),
  KEY `category_id` (`category_id`),
  KEY `version` (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `gk_contact_messages`
--

DROP TABLE IF EXISTS `gk_contact_messages`;
CREATE TABLE `gk_contact_messages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) DEFAULT NULL,
  `status` tinyint(10) DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `contact_id` (`contact_id`),
  KEY `ip_address` (`ip_address`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
--
-- Table structure for table `gk_cronscheduler_items`
--

--
-- Table structure for table `gk_cronscheduler_items`
--

DROP TABLE IF EXISTS `gk_cronscheduler_items`;
CREATE TABLE IF NOT EXISTS `gk_cronscheduler_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `cron` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `date_lastrun_start` datetime DEFAULT NULL COMMENT 'Last Start',
  `date_lastrun_end` datetime DEFAULT NULL COMMENT 'Last Run',
  `date_expected_next_run` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `command_type` tinyint(1) DEFAULT NULL,
  `command_internal` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `command_external_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `send_email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `is_system_cron` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `command_internal` (`command_internal`),
  KEY `date_expected_next_run` (`date_expected_next_run`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_cronscheduler_log`
--

DROP TABLE IF EXISTS `gk_cronscheduler_log`;
CREATE TABLE IF NOT EXISTS `gk_cronscheduler_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cron_id` bigint(20) DEFAULT NULL,
  `cron` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_start` datetime DEFAULT NULL COMMENT 'Last Start',
  `date_end` datetime DEFAULT NULL COMMENT 'Last Run',
  `date_expected_next_run` datetime DEFAULT NULL,
  `command` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `crond_id_date_expected_next_run` (`cron_id`,`date_expected_next_run`),
  KEY `cron_id` (`cron_id`),
  KEY `date_expected_next_run` (`date_expected_next_run`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `gk_stats_dailyhits`
--

DROP TABLE IF EXISTS `gk_stats_dailyhits`;
CREATE TABLE IF NOT EXISTS `gk_stats_dailyhits` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_created` date DEFAULT NULL,
  `hit_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------


--
-- Table structure for table `gk_email_queue_items`
--
DROP TABLE IF EXISTS `gk_email_queue_items`;
CREATE TABLE IF NOT EXISTS `gk_email_queue_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `queue_marker` varchar(36) DEFAULT NULL,  
  `hourly_marker` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL,  
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_subject` TEXT COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_from_name` varchar(127) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_from_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,  
  `field_to_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_to_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_cc_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_cc_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_replyto_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_replyto_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_bcc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,  
  `field_return_receipt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,    
  `field_priority` tinyint(3) NOT NULL DEFAULT 0,
  `field_xmailer` varchar(255) NOT NULL DEFAULT '',
  `store_folder` varchar(255) NOT NULL DEFAULT '', 
  `field_sha1` char(40),
  `status` tinyint(3) DEFAULT '0',
  `retry_count` tinyint(3) DEFAULT '0',
  `date_queued` datetime DEFAULT NULL,
  `date_sent` datetime DEFAULT NULL,
  `date_last_retry` datetime DEFAULT NULL,
  `extra_headers` TEXT COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachments` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `queue_marker` (`queue_marker`),
  KEY `field_to_email` (`field_to_email`),
  KEY `date_sent` (`date_sent`),
  KEY `status` (`status`),
  KEY `hourly_marker` (`hourly_marker`),
  KEY `status_hourly_marker` (`status`, `hourly_marker`),
  KEY `unsent` (`status`,`retry_count`),
  KEY `count_period` (`status`,`date_queued`),
  KEY `date_queued` (`date_queued`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Table structure for table `gk_email_bounce_items`
--
DROP TABLE IF EXISTS `gk_email_bounce_items`;
CREATE TABLE IF NOT EXISTS `gk_email_bounce_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_id` bigint(20),
  `date_created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `gk_email_template_items`
--

DROP TABLE IF EXISTS `gk_email_template_items`;
CREATE TABLE IF NOT EXISTS `gk_email_template_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purpose` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'untitled',
  `body_html` text COLLATE utf8mb4_unicode_ci,
  `body_text` text COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `is_system_message` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  UNIQUE KEY `virtual_filename` (`virtual_filename`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_macro_config`
--

DROP TABLE IF EXISTS `gk_macro_config`;
CREATE TABLE IF NOT EXISTS `gk_macro_config` (
  `section` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `value` text COLLATE utf8mb4_unicode_ci,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified_by_id` bigint(16) NOT NULL DEFAULT '0',
  UNIQUE KEY `primary_key` (`section`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_macro_items`
--

DROP TABLE IF EXISTS `gk_macro_items`;
CREATE TABLE IF NOT EXISTS `gk_macro_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `display_in_apps` tinyint(3) unsigned DEFAULT '1',
  `display_in_blocks` tinyint(3) unsigned DEFAULT '1',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `enabled_apps` text COLLATE utf8mb4_unicode_ci,
  `enabled_blocks` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_global_checkedout_items`
--

DROP TABLE IF EXISTS `gk_global_checkedout_items`;
CREATE TABLE IF NOT EXISTS `gk_global_checkedout_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `checkedout_by_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guid_app_name` (`guid`,`app_name`),
  KEY `app_name` (`app_name`),
  KEY `checkedout_by_id` (`checkedout_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_global_version_items`
--

DROP TABLE IF EXISTS `gk_global_version_items`;
CREATE TABLE IF NOT EXISTS `gk_global_version_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `app_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by_id` bigint(20) unsigned NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guidversion` (`guid`,`version`),
  KEY `date_created` (`date_created`),
  KEY `created_by_id` (`created_by_id`),
  KEY `app_name` (`app_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_html_categories`
--

DROP TABLE IF EXISTS `gk_html_categories`;
CREATE TABLE IF NOT EXISTS `gk_html_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `sort_order` int(3) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned DEFAULT NULL,
  `locked_by_id` bigint(20) DEFAULT NULL,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `description_background_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,

  PRIMARY KEY (`cid`),
  KEY `parent_id` (`parent_id`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `sort_order` (`sort_order`),
  KEY `status` (`status`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  UNIQUE KEY `vfn_parent_id` (`parent_id`, `virtual_filename`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_html_items`
--

DROP TABLE IF EXISTS `gk_html_items`;
CREATE TABLE IF NOT EXISTS `gk_html_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `description_background_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `locked_by_id` bigint(20) DEFAULT NULL,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,

  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `title` (`title`),
  KEY `id_category_id` (`id`,`category_id`),
  KEY `id_category_id_status` (`id`,`category_id`,`status`),
  KEY `id_category_id_status_sort_order` (`id`,`category_id`,`status`,`sort_order`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`),
  UNIQUE KEY `vfn_category_id` (`category_id`, `virtual_filename`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_httperror_items`
--

DROP TABLE IF EXISTS `gk_httperror_items`;
CREATE TABLE IF NOT EXISTS `gk_httperror_items` (
  `id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `status` int(11) NOT NULL DEFAULT '1',
  `summary` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_log_items`
--

DROP TABLE IF EXISTS `gk_log_items`;
CREATE TABLE `gk_log_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT 'system',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT 'info',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,  
  `host_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_uri` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `log_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_mediamanager_categories`
--

DROP TABLE IF EXISTS `gk_mediamanager_categories`;
CREATE TABLE IF NOT EXISTS `gk_mediamanager_categories` (
  `cid` bigint(20) unsigned NOT NULL,
  `parent_id` int(20) unsigned DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) DEFAULT NULL,
  `full_url_path` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_file_path` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid_iteration` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `sort_order` int(3) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `items_per_page` int(11) NOT NULL DEFAULT '10',
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`cid`),
  KEY `parent_id` (`parent_id`),
  KEY `title` (`title`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `date_available` (`date_available`),
  KEY `date_expiry` (`date_expiry`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `sort_order` (`sort_order`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_mediamanager_items`
--

DROP TABLE IF EXISTS `gk_mediamanager_items`;
CREATE TABLE IF NOT EXISTS `gk_mediamanager_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `full_url_path` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_file_path` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid_iteration` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `relative_subsite_url_path` char(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` bigint(20) DEFAULT NULL,
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) DEFAULT NULL,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `status` int(11) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `title` (`title`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `status` (`status`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_menu_categories`
--

DROP TABLE IF EXISTS `gk_menu_categories`;
CREATE TABLE IF NOT EXISTS `gk_menu_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_menu_items`
--

DROP TABLE IF EXISTS `gk_menu_items`;
CREATE TABLE IF NOT EXISTS `gk_menu_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `open_in_new_window` tinyint(1) NOT NULL DEFAULT '1',
  `category_id` int(11) NOT NULL DEFAULT '1',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `sort_order` int(3) DEFAULT NULL,
  `ssl_state` tinyint(2) NOT NULL DEFAULT '0',
  `subtemplate`varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtemplate_inner_pages`varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtemplate_mobile`varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtemplate_mobile_inner_pages`varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,    
  `application` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menuaction` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menuitem` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internalurl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sefurl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customurl` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `font_icon` varchar(63) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_font_icon_only_no_text` tinyint(1) DEFAULT NULL,
  `left_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `right_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_placeholder_only` tinyint(1) NOT NULL DEFAULT '0',
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `status` (`status`),
  KEY `parent_id` (`parent_id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_mutexlock_items`
--

DROP TABLE IF EXISTS `gk_mutexlock_items`;
CREATE TABLE IF NOT EXISTS `gk_mutexlock_items` (
  `process_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timestamp_last_touched` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`process_name`),
  KEY `status` (`status`),
  KEY `timestamp_last_touched` (`timestamp_last_touched`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_theme_items`
--

DROP TABLE IF EXISTS `gk_theme_items`;
CREATE TABLE `gk_theme_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_admin` tinyint(1) NOT NULL DEFAULT '0',
  `subtemplates` text COLLATE utf8mb4_unicode_ci,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_theme_config`
--
DROP TABLE IF EXISTS `gk_theme_config`;
CREATE TABLE `gk_theme_config` (
  `section` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `value` text COLLATE utf8mb4_unicode_ci,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified_by_id` bigint(20) NOT NULL DEFAULT '0',
  UNIQUE KEY `primary_key` (`section`,`key`) 
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `gk_user_categories`
--

DROP TABLE IF EXISTS `gk_user_categories`;
CREATE TABLE IF NOT EXISTS `gk_user_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT '0',
  `groupname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `status` int(11) NOT NULL DEFAULT '0',
  `items_per_page` int(11) NOT NULL DEFAULT '10',
  PRIMARY KEY (`cid`),
  KEY `parent_id` (`parent_id`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_user_categories_items`
--

DROP TABLE IF EXISTS `gk_user_categories_items`;
CREATE TABLE IF NOT EXISTS `gk_user_categories_items` (
  `id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `cid` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_user_history`
--

DROP TABLE IF EXISTS `gk_user_history`;
CREATE TABLE `gk_user_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `host_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,  
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_uri` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `date_created` (`date_created`),
  KEY `ip_address` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
-- --------------------------------------------------------


--
-- Table structure for table `gk_user_password_reset`
--

DROP TABLE IF EXISTS `gk_user_password_reset`;
CREATE TABLE `gk_user_password_reset` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime DEFAULT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirm_ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirm_user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `email_sent_count` tinyint(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `email` (`email`),
  KEY `hash` (`hash`),
  KEY `id_hash` (`id`,`hash`),
  KEY `ip_address` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `gk_user_items`
--

DROP TABLE IF EXISTS `gk_user_items`;
CREATE TABLE IF NOT EXISTS `gk_user_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `salt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `firstname` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `display_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_address` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_email_address` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `public_status` tinyint(1) DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `date_of_birth` datetime DEFAULT NULL,
  `gender` tinyint(1) DEFAULT NULL,
  `cookie` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `session` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_logged_in` timestamp NULL DEFAULT NULL,
  `date_last_failed_login_attempt` timestamp NULL DEFAULT NULL,
  `total_failed_login_attempt` int(11) DEFAULT NULL,
  `activation_string` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `additional_info` mediumtext COLLATE utf8mb4_unicode_ci,
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `facebook_user_id` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `live_user_id` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkedin_user_id` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `yahoo_user_id` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `google_user_id` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `twitter_user_id` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email_address` (`email_address`),
  KEY `facebook_user_id` (`facebook_user_id`),
  KEY `google_user_id` (`google_user_id`),
  KEY `live_user_id` (`live_user_id`),
  KEY `yahoo_user_id` (`yahoo_user_id`),
  KEY `linkedin_user_id` (`linkedin_user_id`),
  KEY `twitter_user_id` (`twitter_user_id`),
  KEY `status` (`status`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Table structure for table `gk_session_handler`
--
DROP TABLE IF EXISTS `gk_session_handler`;
CREATE TABLE `gk_session_handler` (
  `id` char(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip_address` varchar(46) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `data` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Table structure for table `gk_wysiwyg_categories`
--

DROP TABLE IF EXISTS `gk_wysiwyg_categories`;
CREATE TABLE `gk_wysiwyg_categories` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `status` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_default_backend` tinyint(1) DEFAULT NULL,
  `is_default_frontend` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`cid`),
  UNIQUE KEY `title` (`title`),
  UNIQUE KEY `virtual_filename` (`virtual_filename`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `gk_wysiwyg_config`
--

DROP TABLE IF EXISTS `gk_wysiwyg_config`;
CREATE TABLE `gk_wysiwyg_config` (
  `section` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `value` text COLLATE utf8mb4_unicode_ci,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified_by_id` bigint(16) NOT NULL DEFAULT '0',
  UNIQUE KEY `primary_key` (`section`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `gk_wysiwyg_profiles`
--

DROP TABLE IF EXISTS `gk_wysiwyg_profiles`;
CREATE TABLE `gk_wysiwyg_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  `is_system` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `title` (`title`),
  KEY `is_system` (`is_system`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Table structure for table `gk_sites_hosts`
--


DROP TABLE IF EXISTS `gk_sites_hosts`;
CREATE TABLE `gk_sites_hosts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `hostname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `status` int(11) NOT NULL DEFAULT '0',
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Table structure for table `gk_sites_websites`
--


DROP TABLE IF EXISTS `gk_sites_websites`;
CREATE TABLE `gk_sites_websites` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `mail_default_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Untitled',
  `mail_default_sender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `db_host` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `db_database` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_timezone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------
--
-- Table structure for table `gk_landing_categories`
--
DROP TABLE IF EXISTS `gk_landing_categories`;
CREATE TABLE IF NOT EXISTS `gk_landing_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `sort_order` int(3) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned DEFAULT NULL,
  `locked_by_id` bigint(20) DEFAULT NULL,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_css` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_javascript` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_header` mediumtext COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,

  PRIMARY KEY (`cid`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `sort_order` (`sort_order`),
  KEY `status` (`status`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_landing_items`
--
DROP TABLE IF EXISTS `gk_landing_items`;
CREATE TABLE IF NOT EXISTS `gk_landing_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `locked_by_id` bigint(20) DEFAULT NULL,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,

  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `title` (`title`),
  KEY `id_category_id` (`id`,`category_id`),
  KEY `id_category_id_status` (`id`,`category_id`,`status`),
  KEY `id_category_id_status_sort_order` (`id`,`category_id`,`status`,`sort_order`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
 

-- --------------------------------------------------------

--
-- Table structure for table `gk_cache_items`
--

DROP TABLE IF EXISTS `gk_cache_items`;
CREATE TABLE IF NOT EXISTS `gk_cache_items` (
  `cache_key` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `cache_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_expiry` datetime NOT NULL,
  PRIMARY KEY (`cache_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Table structure for table `gk_user_sessions`
--

DROP TABLE IF EXISTS `gk_user_sessions`;
CREATE TABLE IF NOT EXISTS `gk_user_sessions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `session_time` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_string` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_cookie` char(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_uid` char(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_last_seen` datetime DEFAULT NULL,
  `valid` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_string` (`session_string`),
  KEY `user_id` (`user_id`),
  KEY `session_cookie` (`session_cookie`),
  KEY `session_uid` (`session_uid`),
  KEY `valid` (`valid`),
  KEY `session_lookup` (`session_cookie`,`session_uid`, `valid`)

) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------
--
-- Table structure for table `gk_tag_categories`
--
DROP TABLE IF EXISTS `gk_tag_categories`;
CREATE TABLE IF NOT EXISTS `gk_tag_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `sort_order` int(3) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned DEFAULT NULL,
  `locked_by_id` bigint(20) DEFAULT NULL,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,

  PRIMARY KEY (`cid`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `sort_order` (`sort_order`),
  KEY `status` (`status`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_tag_items`
--
DROP TABLE IF EXISTS `gk_tag_items`;
CREATE TABLE IF NOT EXISTS `gk_tag_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime DEFAULT NULL,
  `internalurl` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `application` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',

  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `application` (`application`),
  KEY `guid` (`guid`),
  UNIQUE KEY `guid_category_id` (`guid`, `category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
 

--
-- Table structure for table `gk_user_sessions`
--

DROP TABLE IF EXISTS `gk_rate_limit`;
CREATE TABLE IF NOT EXISTS `gk_rate_limit` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_details` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,  
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `retry_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ip_address` (`ip_address`),
  KEY `date_created` (`date_created`),
  KEY `rate_limit_lookup` (`date_created`,`ip_address`,`action`, `status`)

) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------
--
-- Table structure for table `gk_hook_categories`
--
DROP TABLE IF EXISTS `gk_hook_functions`;
CREATE TABLE IF NOT EXISTS `gk_hook_functions` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `function_name` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `date_created` datetime DEFAULT NULL,
  PRIMARY KEY (`cid`),
  UNIQUE KEY `function_name` (`function_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Table structure for table `gk_hook_items`
--
DROP TABLE IF EXISTS `gk_hook_classes`;
CREATE TABLE IF NOT EXISTS `gk_hook_classes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime DEFAULT NULL,
  `sort_order` int(11) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `class_name` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',

  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `category_status` (`category_id`,`status`),
  KEY `class_name` (`class_name`),
  UNIQUE KEY `category_id_class_name` (`category_id`, `class_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
 


--
-- Table structure for table `gk_media_header_items`
--

DROP TABLE IF EXISTS `gk_media_header_items`;
CREATE TABLE IF NOT EXISTS `gk_media_header_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `app_class` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_dir` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_file_media` text COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `created_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',

  PRIMARY KEY (`id`),
  KEY `app_class` (`app_class`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  UNIQUE KEY `app_class_guid` (`app_class`, `guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

 
--
-- Table structure for table `gk_customfield_tables`
--

DROP TABLE IF EXISTS `gk_customfield_tables`;
CREATE TABLE `gk_customfield_tables` (
  `cid` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `table_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  PRIMARY KEY (`cid`),
  KEY `table_name` (`table_name`)

) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
--
-- Table structure for table `gk_customfield_items`
--
DROP TABLE IF EXISTS `gk_customfield_items`;
CREATE TABLE `gk_customfield_items` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `field_label` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `field_type` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `field_box_ui` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_unsigned` tinyint(1) NOT NULL,
  `field_length` bigint(20) NOT NULL DEFAULT '0',
  `field_precision` smallint(6) NOT NULL,
  `field_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `field_null` tinyint(1) NOT NULL DEFAULT '0',
  `field_default` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_choices` text COLLATE utf8mb4_unicode_ci,
  `field_choices_use_sql` tinyint(1) NOT NULL,
  `field_choices_sql` text COLLATE utf8mb4_unicode_ci,
  `field_regex_validation` text COLLATE utf8mb4_unicode_ci,
  `field_required` tinyint(1) NOT NULL DEFAULT '0',
  `field_placeholder` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_hint` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `created_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',

  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `field_name` (`field_name`),
  UNIQUE KEY `category_id_field_name` (`category_id`,`field_name`)

) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------
--
-- Table structure for table `gk_gallery_categories`
--
DROP TABLE IF EXISTS `gk_gallery_categories`;
CREATE TABLE `gk_gallery_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `sort_order` int(3) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned DEFAULT NULL,
  `locked_by_id` bigint(20) DEFAULT NULL,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `non_public` tinyint(1) NOT NULL DEFAULT '0',
  `processed` tinyint(1) NOT NULL,
  `thumbnail_width` int(11) unsigned NOT NULL DEFAULT '0',
  `thumbnail_height` int(11) unsigned NOT NULL DEFAULT '0',
  `thumbnail_quality` int(11) unsigned NOT NULL DEFAULT '0',
  `small_width` int(11) unsigned NOT NULL DEFAULT '0',
  `small_height` int(11) unsigned NOT NULL DEFAULT '0',
  `small_quality` int(11) unsigned NOT NULL DEFAULT '0',
  `medium_width` int(11) unsigned NOT NULL DEFAULT '0',
  `medium_height` int(11) unsigned NOT NULL DEFAULT '0',
  `medium_quality` int(11) unsigned NOT NULL DEFAULT '0',
  `large_width` int(11) unsigned NOT NULL DEFAULT '0',
  `large_height` int(11) unsigned NOT NULL DEFAULT '0',
  `large_quality` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  KEY `parent_id` (`parent_id`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `sort_order` (`sort_order`),
  KEY `status` (`status`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  UNIQUE KEY `vfn_parent_id` (`parent_id`, `virtual_filename`),
  UNIQUE KEY `guid` (`guid`),
  KEY `non_public` (`non_public`)

) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gk_gallery_items`
--
DROP TABLE IF EXISTS `gk_gallery_items`;
CREATE TABLE `gk_gallery_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `locked_by_id` bigint(20) DEFAULT NULL,
  `permission_write` text COLLATE utf8mb4_unicode_ci,
  `permission_read` text COLLATE utf8mb4_unicode_ci,
  `meta_key` text COLLATE utf8mb4_unicode_ci,
  `meta_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_dir` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `url_media_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `crop_x` int(11) NOT NULL DEFAULT '0',
  `crop_y` int(11) NOT NULL DEFAULT '0',
  `crop_w` int(11) NOT NULL DEFAULT '0',
  `crop_h` int(11) NOT NULL DEFAULT '0',
  `crop_img_width` int(11) NOT NULL DEFAULT '0',
  `crop_img_height` int(11) NOT NULL DEFAULT '0',
  `exif_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,

  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `title` (`title`),
  KEY `id_category_id` (`id`,`category_id`),
  KEY `id_category_id_status` (`id`,`category_id`,`status`),
  KEY `id_category_id_status_sort_order` (`id`,`category_id`,`status`,`sort_order`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`),
  KEY `parent_dir` (`parent_dir`),
  UNIQUE KEY `vfn_category_id` (`category_id`, `virtual_filename`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
 
--
-- Table structure for table `gk_redirection_items`
--

DROP TABLE IF EXISTS `gk_redirection_items`;
CREATE TABLE IF NOT EXISTS `gk_redirection_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` int(11) NOT NULL DEFAULT '301',
  `path` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `redirect_to` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `status` smallint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',

  PRIMARY KEY (`id`),
  UNIQUE KEY `path` (`path`),
  KEY `redirect_to` (`redirect_to`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `created_by_id` (`created_by_id`),
  KEY `status` (`status`),

  UNIQUE KEY `guid` (`guid`)

) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `gk_404_error_items`
--
DROP TABLE IF EXISTS `gk_404_error_items`;

CREATE TABLE `gk_404_error_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `hits` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `gk_gdpr_items`
--



DROP TABLE IF EXISTS `gk_gdpr_items`;
CREATE TABLE IF NOT EXISTS `gk_gdpr_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_address` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_type` smallint(2) NOT NULL DEFAULT '0',  
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',  
  `auth_code` int(11) unsigned NOT NULL DEFAULT '0',  
  `reason` text COLLATE utf8mb4_unicode_ci,  
  `date_created` datetime DEFAULT NULL,
  `date_confirmed` datetime DEFAULT NULL,  
  `date_expiry` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',  
  `status` int(11) NOT NULL DEFAULT '0',


  PRIMARY KEY (`id`),
  KEY `email_address` (`email_address`),
  KEY `user_id` (`user_id`),
  KEY `date_created` (`date_created`),
  KEY `date_confirmed` (`date_confirmed`),  
  KEY `status` (`status`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

 
-- --------------------------------------------------------
--
-- Table structure for table `gk_extgallery_categories`
--
DROP TABLE IF EXISTS `gk_extgallery_categories`;
CREATE TABLE IF NOT EXISTS `gk_extgallery_categories` (
  `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `sort_order` int(3) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `version` decimal(20,2) NOT NULL DEFAULT '1.00',
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,

  PRIMARY KEY (`cid`),
  KEY `parent_id` (`parent_id`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `sort_order` (`sort_order`),
  KEY `status` (`status`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `gk_extgallery_items`
--
DROP TABLE IF EXISTS `gk_extgallery_items`;
CREATE TABLE IF NOT EXISTS `gk_extgallery_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `url_icon` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `summary` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `locked_by_id` bigint(20) DEFAULT NULL,
  `permission_write` text COLLATE utf8_unicode_ci,
  `permission_read` text COLLATE utf8_unicode_ci,
  `meta_key` text COLLATE utf8_unicode_ci,
  `meta_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `pageview` bigint(20) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
`sort_order` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
 `is_app` tinyint(1) NOT NULL,
 `is_block` tinyint(1) NOT NULL,
 `is_macro` tinyint(1) NOT NULL,
 `is_theme` tinyint(1) DEFAULT NULL,
 `is_wysiwyg` tinyint(1) DEFAULT NULL,

  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `category_guid` (`category_guid`),
  KEY `title` (`title`),
  KEY `id_category_id` (`id`,`category_id`),
  KEY `id_category_id_status` (`id`,`category_id`,`status`),
  KEY `id_category_id_status_sort_order` (`id`,`category_id`,`status`,`sort_order`),
  KEY `virtual_filename` (`virtual_filename`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `created_by_id` (`created_by_id`),
  KEY `modified_by_id` (`modified_by_id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
 
-- --------------------------------------------------------
--
-- Table structure for table `gk_extgallery_downloads`
--
DROP TABLE IF EXISTS `gk_extgallery_downloads`;
CREATE TABLE IF NOT EXISTS `gk_extgallery_downloads` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ext_version` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `url_download` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `download_filename` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `change_log` mediumtext COLLATE utf8mb4_unicode_ci,
  `sha1_hash` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `file_size` bigint(20) unsigned NOT NULL DEFAULT '0',
  `min_schlix_version` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `max_schlix_version` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `download_count` bigint(20) NOT NULL DEFAULT '0',
  `is_current_stable` tinyint(1) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',

  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_guid` (`item_guid`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `download_filename` (`download_filename`),
  KEY `sha1_hash` (`sha1_hash`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
 

-- --------------------------------------------------------
--
-- Table structure for table `gk_extgallery_screenshots`
--

DROP TABLE IF EXISTS `gk_extgallery_screenshots`;
CREATE TABLE IF NOT EXISTS `gk_extgallery_screenshots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `url_image_small` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `url_image_large` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `download_count` bigint(20) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',

  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_guid` (`item_guid`),
  KEY `title` (`title`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  UNIQUE KEY `guid` (`guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------------------------------------- 
--
-- Table structure for table `gk_extmanager_items`
--

DROP TABLE IF EXISTS `gk_extmanager_items`;
CREATE TABLE IF NOT EXISTS `gk_extmanager_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ext_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `version_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `installed_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',  
  `is_outdated` tinyint(1) NOT NULL DEFAULT '0',  
  `file_list` mediumtext COLLATE utf8mb4_unicode_ci,  

  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `date_modified` (`date_modified`),
  KEY `is_outdated` (`is_outdated`),
  UNIQUE KEY `ext_guid` (`ext_guid`),
  UNIQUE KEY `ext_guid_version` (`ext_guid`,`version_guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

 

